<?php
// Receveur de données envoyées par le client, qui utilise AJAX
// Enregistre le texte reçu dans le fichier ./data.txt
// Ce texte sera lu par le client : "ajax_recepteur.html" + "php_envoie_au_recepteur.php"

// Lecture des données
if (!isset($_POST['param1'])) { 
  exit();
  }
else {
  $dataIn = $_POST['param1'];
  }

// TEST
echo $dataIn; // Test pour voir côté client le texte reçu par le serveur.

// Ecrit dans les 4 fichiers, pour les 4 destinataires.
$aFichiers = array("./data1.txt", "./data2.txt", "./data3.txt", "./data4.txt");

foreach ($aFichiers as $fichier) {
  if (!file_exists($fichier)) {
    // Crée le fichier vide
    file_put_contents($fichier, '');
    }

  // Ouvre le fichier  $fichier  en écriture
  $fp = @fopen($fichier, "w"); // le fichier est ouvert en ecriture, remis a zero

  // Teste si le fichier  $fichier  existe et peut être modifié.
  if (!$fp) {
    // PAS normal, le fichier devrait exister et être accessible en écriture.
    echo "Impossible d'ouvrir $fichier en ecriture";
    exit();
    }

  // Le contenu du fichier est remplacé par les nouvelles données
  fputs($fp, $dataIn);
  fclose($fp); // Ferme le fichier.

  // Plus simple que ce qui précède :
  // Crée le fichier s'il n'existe pas, ou ajoute du contenu s'il existe
  //file_put_contents('data0.txt', '', FILE_APPEND); // Crée un fichier vide
  // OU
  //file_put_contents('data0.txt', $dataIn."\n", FILE_APPEND); // Ajoute une ligne
  //file_put_contents('data0.txt', $dataIn); // Écrase le contenu du fichier et écrit une ligne

  // Il faut avoir marqué le dossier chat04 en écriture pour tout le monde.
  } // foreach