<?php
// Envoie au client, qui utilise AJAX, le contenu du fichier ./data.txt lorsqu'il aura changé.
// Boucle pour lire le contenu du fichier ./data.txt, pour voir s'il a changé.
// Si OUI, envoie le texte au client
// Si NON, continue de boucler un certain temps
// Si après un certain temps TIMEOUT, le fichier ./data.txt n'a pas changé, 
// envoie un texte vide.
// S'il a reçu un texte, il l'enregistre dans le fichier ./data.txt

// Lecture des données
if (!isset($_POST['param1'])) { 
  exit();
  }
else {
  $dataIn = $_POST['param1'];
  }

// Ainsi affiche le nom de receveur.
//echo $dataIn; // Test pour voir côté client le texte reçu par le serveur.

// nom du fichier dans lequel les données seront sauvées
if ($dataIn[2] === "1") {
  // Texte émis par le Client Bg1
  $fichier = "./data1.txt"; 
  }
elseif ($dataIn[2] == "2") {
  // Texte émis par le Client Bg2
  $fichier = "./data2.txt"; 
  }
elseif ($dataIn[2] == "3") {
  // Texte émis par le Client Bg3
  $fichier = "./data3.txt"; 
  }
else {
  // Sinon, c'est le client Bg4 qui a émis le texte.
  $fichier = "./data4.txt"; 
  }

if (!file_exists($fichier)) {
  // Crée le fichier vide
  file_put_contents($fichier, '');
  }

$timeout = 20; // Timeout en secondes
while ($timeout > 0) {
  // Boucle pour voir si le fichier ./data.txt a changé
  $timeout -= 1;

  // Ouvre le fichier  $fichier  en lecture
  $fp = @fopen($fichier, "r");

    // Teste si le fichier  $fichier  existe et peut être lu
    if (!$fp) {
       // Pas normal, que faire ??? Peut-être que le fichier n'existe pas.
       echo "<br>";
       echo "Impossible d'ouvrir $fichier en lecture";
       exit();
       }

  // Le contenu du fichier est remplacé par les nouvelles données
  //$dataOut = fread($fp, filesize($fichier)); // N'a pas fonctionné, pourquoi ?
  $dataOut = fread($fp, 100);   // fgets($fp, 80); Si on ne désire lire qu'une seule ligne de texte.
  fclose($fp); // Ferme le fichier.
  
  if (strlen($dataOut) > 1) {
    // Il y a un texte dans le fichier, donc l'envoie au destinataire.
    
    // Ouvre le fichier  $fichier  en écriture
    $fp = @fopen($fichier, "w"); // le fichier est ouvert en ecriture, remis a zero

    // Test si le fichier  $fichier  existe et peut être modifié
    if (!$fp) {
      echo "<br>";
      echo "Impossible d'ouvrir $fichier en ecriture";
      exit();
      }

    // Efface le contenu du fichier, ce qui indiquera que le texte qu'il contenait a été envoyé au client.
    fputs($fp, "");
    fclose($fp); // Ferme le fichier.
    
    echo $dataOut;
    exit();
    } // if

  sleep(1); // Attend une seconde
  } // while

echo ""; // Indique qu'il n'y a pas eu de nouveau texte venant de l'émetteur.
